<?php
header('Content-Type: application/json');
session_start(); // Start session to access $_SESSION

require_once 'security/chart_connection.php';

// Get selected month and year from GET request
$month = isset($_GET['month']) ? (int)$_GET['month'] : date('m');
$year = isset($_GET['year']) ? (int)$_GET['year'] : date('Y');

// Get user_type and sal_ex from session
$user_type = isset($_SESSION['User_Type']) ? (int)$_SESSION['User_Type'] : null;
$salEx = isset($_SESSION['CURRENT_REP']) ? $_SESSION['CURRENT_REP'] : null;

if ($user_type === null) {
    echo json_encode(["error" => "User Type not defined in session"]);
    exit;
}

$salesData = [];
$cumulativeTotal = 0;

if ($user_type === 1) {
    // Manager: fetch total sales for all
    $salesQuery = "SELECT DATE(SDATE) as sale_date, SUM(GRAND_TOT) as total_sales 
                   FROM s_salma 
                   WHERE CANCELL = 0 AND MONTH(SDATE) = ? AND YEAR(SDATE) = ?
                   GROUP BY DATE(SDATE)";
    $stmt = $conn->prepare($salesQuery);
    $stmt->bind_param("ii", $month, $year);
} else {
    // Sales rep or other roles: filter by SAL_EX
    if (!$salEx) {
        echo json_encode(["error" => "Sales executive not defined in session"]);
        exit;
    }

    $salesQuery = "SELECT DATE(SDATE) as sale_date, SUM(GRAND_TOT) as total_sales 
                   FROM s_salma 
                   WHERE CANCELL = 0 AND MONTH(SDATE) = ? AND YEAR(SDATE) = ? AND SAL_EX = ?
                   GROUP BY DATE(SDATE)";
    $stmt = $conn->prepare($salesQuery);
    $stmt->bind_param("iis", $month, $year, $salEx);
}

$stmt->execute();
$salesResult = $stmt->get_result();

while ($row = $salesResult->fetch_assoc()) {
    $cumulativeTotal += $row['total_sales'];
    $salesData[$row['sale_date']] = $cumulativeTotal;
}
$stmt->close();

$targetData = [];
$totalTargetValue = 0;

if ($user_type !== 1) {
    // Fetch target data only for employees/sales reps
    if (!$salEx) {
        echo json_encode(["error" => "Sales executive not defined in session for target data"]);
        exit;
    }

    $targetQuery = "SELECT DATE(month) as target_date, SUM(target) as total_target 
                    FROM rep_targetbrand 
                    WHERE MONTH(month) = ? AND YEAR(month) = ? AND rep = ?
                    GROUP BY MONTH(month)";
    $stmt = $conn->prepare($targetQuery);
    $stmt->bind_param("iis", $month, $year, $salEx);
    $stmt->execute();
    $targetResult = $stmt->get_result();

    while ($row = $targetResult->fetch_assoc()) {
        $targetData[$row['target_date']] = $row['total_target'];
        $totalTargetValue += $row['total_target'];
    }
    $stmt->close();
}

$conn->close();

// Return data as JSON
echo json_encode([
    "salesData" => $salesData,
    "targetData" => $targetData,
    "totalTargetValue" => $totalTargetValue,
    "userType" => $user_type
]);
?>
