<?php

$host = 'localhost';
$user = 'root';
$pass = '';
$db = 'SWijesooriya_tht';
$conn = mysqli_connect($host, $user, $pass, $db);

if (!$conn) {
    die("Connection failed: " . mysqli_connect_error());
}

// Set default timezone
date_default_timezone_set('UTC');

// Get current date
$currentDate = date('Y-m-d');
$displayDate = date('d/m/Y');

// Load REPCODE from s_salrep table
$repcodeOptions = '';
$repcodeQuery = "SELECT DISTINCT sal_ex FROM s_salrep ORDER BY sal_ex";
$repcodeResult = mysqli_query($conn, $repcodeQuery);
$repcodeData = [];
if ($repcodeResult && mysqli_num_rows($repcodeResult) > 0) {
    while ($row = mysqli_fetch_assoc($repcodeResult)) {
        $selected = (isset($_POST['repcode']) && $_POST['repcode'] == $row['sal_ex']) ? 'selected' : '';
        $repcodeOptions .= "<option value='{$row['sal_ex']}' $selected>{$row['sal_ex']}</option>";
        $repcodeData[] = $row['sal_ex'];
    }
}

// Handle search and data loading
$searchResults = [];
$selectedStock = null;
$stockDetails = [];
$transactionData = [];
$salesData = [];
$customerSales = [];
$monthlySalesByRepcode = [];
$inventoryDate = '2024-01-01'; // Set your inventory date here or make it dynamic

$searchTerm = '';
$selectedRepcode = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Get search term
    $searchTerm = isset($_POST['search_term']) ? mysqli_real_escape_string($conn, $_POST['search_term']) : '';
    
    // Get selected REPCODE
    $selectedRepcode = isset($_POST['repcode']) ? mysqli_real_escape_string($conn, $_POST['repcode']) : '';
    
    // Search in s_mas
    if (!empty($searchTerm)) {
        $searchQuery = "SELECT STK_NO, DESCRIPT, BRAND_NAME, QTYINHAND 
                        FROM s_mas 
                        WHERE STK_NO LIKE '%$searchTerm%' OR DESCRIPT LIKE '%$searchTerm%'
                        LIMIT 100";
        $searchResult = mysqli_query($conn, $searchQuery);
        
        if ($searchResult && mysqli_num_rows($searchResult) > 0) {
            while ($row = mysqli_fetch_assoc($searchResult)) {
                $searchResults[] = $row;
            }
        }
    }
    
    // Get details for selected stock
    if (isset($_POST['stock_no']) && !empty($_POST['stock_no'])) {
        $stockNo = mysqli_real_escape_string($conn, $_POST['stock_no']);
        $selectedStock = $stockNo;
        
        // Get stock details from view_stomas_submas
        $stockQuery = "SELECT DESCRIPTION, STO_CODE, QTYINHAND 
                       FROM view_stomas_submas 
                       WHERE STK_NO = '$stockNo'";
        $stockResult = mysqli_query($conn, $stockQuery);
        
        if ($stockResult && mysqli_num_rows($stockResult) > 0) {
            while ($row = mysqli_fetch_assoc($stockResult)) {
                $stockDetails[] = $row;
            }
        }
        
        // Get transaction data from s_trn with balance calculation
        $transactionQuery = "SELECT SDATE, REFNO, QTY, LEDINDI, tru_qty, sal_ex 
                       FROM s_trn 
                       WHERE STK_NO = '$stockNo' AND SDATE >= '$inventoryDate'
                       ORDER BY SDATE, REFNO";
        $transactionResult = mysqli_query($conn, $transactionQuery);
        
        $runningBalance = 0;
        if ($transactionResult && mysqli_num_rows($transactionResult) > 0) {
            while ($row = mysqli_fetch_assoc($transactionResult)) {
                // Calculate running balance based on transaction type
                if (strpos($row['LEDINDI'], 'SUP') !== false) {
                    // Supplier = Purchase (increase stock)
                    $runningBalance += $row['QTY'];
                } elseif (strpos($row['LEDINDI'], 'CUS') !== false || strpos($row['LEDINDI'], 'SAL') !== false) {
                    // Customer/Sale = Sale (decrease stock)
                    $runningBalance -= $row['QTY'];
                } else {
                    // Other transactions
                    $runningBalance += $row['QTY'];
                }
                $row['BALANCE'] = $runningBalance;
                $transactionData[] = $row;
            }
        }
        
        // Get sales data from view_salma_sinvo for calculations
        $salesQuery = "SELECT SDATE, REFNO, QTY, CUS_NAME, SAL_EX, COST, PRICE 
                       FROM view_salma_sinvo 
                       WHERE STK_NO = '$stockNo'
                       ORDER BY SDATE DESC ";
        $salesResult = mysqli_query($conn, $salesQuery);
        
        if ($salesResult && mysqli_num_rows($salesResult) > 0) {
            while ($row = mysqli_fetch_assoc($salesResult)) {
                $salesData[] = $row;
            }
        }
        
        // Get customer sales for current month
        $currentMonth = date('Y-m');
        $customerQuery = "SELECT CUS_NAME, SUM(QTY) as total_qty 
                          FROM view_salma_sinvo 
                          WHERE STK_NO = '$stockNo' AND DATE_FORMAT(SDATE, '%Y-%m') = '$currentMonth'
                          GROUP BY CUS_NAME
                          ORDER BY total_qty DESC";
        $customerResult = mysqli_query($conn, $customerQuery);
        
        if ($customerResult && mysqli_num_rows($customerResult) > 0) {
            while ($row = mysqli_fetch_assoc($customerResult)) {
                $customerSales[] = $row;
            }
        }
    }
    
    // Get monthly sales for selected REPCODE (last 6 months)
    if (!empty($selectedRepcode)) {
        $sixMonthsAgo = date('Y-m', strtotime('-5 months'));
        $monthlyRepcodeQuery = "SELECT DATE_FORMAT(SDATE, '%Y-%m') as month, SUM(QTY) as total_qty 
                              FROM view_salma_sinvo 
                              WHERE SAL_EX = '$selectedRepcode' AND DATE_FORMAT(SDATE, '%Y-%m') >= '$sixMonthsAgo'
                              GROUP BY DATE_FORMAT(SDATE, '%Y-%m')
                              ORDER BY month";
        $monthlyRepcodeResult = mysqli_query($conn, $monthlyRepcodeQuery);
        
        if ($monthlyRepcodeResult && mysqli_num_rows($monthlyRepcodeResult) > 0) {
            while ($row = mysqli_fetch_assoc($monthlyRepcodeResult)) {
                $monthlySalesByRepcode[] = $row;
            }
        }
    }
}

// Calculate sales statistics
function calculateSalesStats($salesData) {
    $stats = [
        'total_sales_qty' => 0,
        'total_revenue' => 0,
        'total_cost' => 0,
        'total_profit' => 0,
        'sale_count' => 0
    ];
    
    foreach ($salesData as $sale) {
        $stats['total_sales_qty'] += $sale['QTY'];
        $stats['total_revenue'] += $sale['PRICE'] * $sale['QTY'];
        $stats['total_cost'] += $sale['COST'] * $sale['QTY'];
        $stats['sale_count']++;
    }
    
    $stats['total_profit'] = $stats['total_revenue'] - $stats['total_cost'];
    $stats['profit_margin'] = $stats['total_cost'] > 0 ? ($stats['total_profit'] / $stats['total_cost']) * 100 : 0;
    
    return $stats;
}

// Function to get LED indicator type
function getLedType($ledindi) {
    if (strpos($ledindi, 'CUS') !== false) return 'customer';
    if (strpos($ledindi, 'SUP') !== false) return 'supplier';
    if (strpos($ledindi, 'SAL') !== false) return 'sale';
    return 'other';
}

// Function to get transaction color class
function getTransactionColorClass($ledindi) {
    if (strpos($ledindi, 'SUP') !== false) return 'trn-purchase';
    if (strpos($ledindi, 'CUS') !== false || strpos($ledindi, 'SAL') !== false) return 'trn-sale';
    return 'trn-other';
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Stock System</title>
    <style>
        * {
            font-size: 11px;
            font-family: Arial, sans-serif;
        }
        body {
            margin: 2px;
            padding: 2px;
            background-color: #f0f0f0;
        }
        .header {
            background: #2c3e50;
            color: white;
            padding: 4px 8px;
            margin-bottom: 4px;
            border-radius: 3px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        .header h1 {
            font-size: 14px;
            margin: 2px 0;
        }
        .date-display {
            font-size: 11px;
            font-weight: bold;
            background: rgba(255,255,255,0.2);
            padding: 3px 8px;
            border-radius: 3px;
        }
        .control-panel {
            background: white;
            padding: 6px;
            margin-bottom: 4px;
            border-radius: 3px;
            border: 1px solid #ccc;
            display: flex;
            gap: 10px;
            align-items: center;
        }
        .combo-section {
            display: flex;
            align-items: center;
            gap: 5px;
        }
        .combo-section label {
            font-weight: bold;
            white-space: nowrap;
        }
        .combo-section select {
            padding: 3px;
            border: 1px solid #999;
            border-radius: 2px;
            min-width: 120px;
        }
        .search-box {
            flex: 1;
            padding: 4px;
            border: 1px solid #999;
            border-radius: 2px;
            min-width: 200px;
        }
        .search-info {
            color: #666;
            padding: 2px 4px;
            background: #f8f9fa;
            border-radius: 2px;
            margin-top: 2px;
        }
        .grid-container {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 4px;
            margin-bottom: 4px;
        }
        .grid-section {
            background: white;
            padding: 4px;
            border-radius: 3px;
            border: 1px solid #ccc;
            overflow: hidden;
            display: flex;
            flex-direction: column;
        }
        .grid-section.full-width {
            grid-column: 1 / -1;
        }
        .section-title {
            font-size: 11px;
            font-weight: bold;
            color: #2c3e50;
            border-bottom: 1px solid #3498db;
            padding: 2px 0;
            margin-bottom: 3px;
            display: flex;
            align-items: center;
            gap: 4px;
        }
        .grid-wrapper {
            flex: 1;
            overflow: auto;
            border: 1px solid #e0e0e0;
            max-height: 250px;
        }
        .grid {
            width: 100%;
            border-collapse: collapse;
            font-size: 10px;
        }
        .grid th {
            background: #3498db;
            color: white;
            padding: 3px 4px;
            text-align: left;
            font-weight: bold;
            position: sticky;
            top: 0;
            border: 1px solid #2980b9;
        }
        .grid td {
            border: 1px solid #e0e0e0;
            padding: 2px 4px;
            text-align: left;
        }
        .grid tr:nth-child(even) {
            background-color: #f8f9fa;
        }
        .grid tr:hover {
            background-color: #e3f2fd;
            cursor: pointer;
        }
        .grid tr.selected {
            background-color: #bbdefb;
            border-left: 2px solid #2196f3;
        }
        .qty-high { background-color: #e8f5e8 !important; color: #2e7d32; font-weight: bold; }
        .qty-low { background-color: #ffebee !important; color: #c62828; font-weight: bold; }
        .profit-high { background-color: #e8f5e8 !important; color: #2e7d32; }
        .profit-low { background-color: #ffebee !important; color: #c62828; }
        .led-customer { background-color: #e3f2fd !important; }
        .led-supplier { background-color: #f3e5f5 !important; }
        .led-sale { background-color: #e8f5e8 !important; }
        
        /* Transaction row colors */
        .trn-purchase { background-color: #e8f5e9 !important; border-left: 3px solid #4caf50; }
        .trn-sale { background-color: #ffebee !important; border-left: 3px solid #f44336; }
        .trn-other { background-color: #fff3e0 !important; border-left: 3px solid #ff9800; }
        
        /* Balance column styling */
        .balance-positive { 
            background-color: #c8e6c9 !important; 
            color: #1b5e20; 
            font-weight: bold;
            text-align: center;
        }
        .balance-negative { 
            background-color: #ffcdd2 !important; 
            color: #b71c1c; 
            font-weight: bold;
            text-align: center;
        }
        .balance-zero { 
            background-color: #fff9c4 !important; 
            color: #f57f17; 
            font-weight: bold;
            text-align: center;
        }
        
        /* Inventory filter info */
        .inventory-filter {
            background: #fff3cd;
            border: 1px solid #ffc107;
            padding: 4px 8px;
            border-radius: 3px;
            margin-bottom: 3px;
            font-size: 9px;
            color: #856404;
        }
        
        .chart-container {
            background: white;
            padding: 6px;
            margin-bottom: 4px;
            border-radius: 3px;
            border: 1px solid #ccc;
        }
        .chart-title {
            font-size: 11px;
            font-weight: bold;
            color: #2c3e50;
            border-bottom: 1px solid #3498db;
            padding: 2px 0;
            margin-bottom: 4px;
            display: flex;
            align-items: center;
            gap: 4px;
        }
        .chart {
            width: 100%;
            height: 150px;
            background: #f9f9f9;
            border: 1px solid #e0e0e0;
            margin-bottom: 4px;
            display: flex;
            align-items: flex-end;
            padding: 4px;
            box-sizing: border-box;
        }
        .chart-bar-container {
            flex: 1;
            display: flex;
            flex-direction: column;
            align-items: center;
            height: 100%;
            margin: 0 1px;
        }
        .chart-bar {
            width: 90%;
            background: #3498db;
            border-radius: 2px 2px 0 0;
            position: relative;
            transition: all 0.2s ease;
            min-height: 2px;
        }
        .chart-bar:hover {
            opacity: 0.8;
        }
        .chart-label {
            text-align: center;
            font-size: 8px;
            margin-top: 2px;
            font-weight: bold;
            color: #2c3e50;
        }
        .chart-value {
            position: absolute;
            top: -15px;
            left: 50%;
            transform: translateX(-50%);
            font-size: 8px;
            font-weight: bold;
            color: #2c3e50;
            background: rgba(255,255,255,0.9);
            padding: 1px 3px;
            border-radius: 1px;
            white-space: nowrap;
        }
        .customer-chart .chart-bar { background: #e74c3c; }
        .repcode-chart .chart-bar { background: #2ecc71; }
        .stats-bar {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(80px, 1fr));
            gap: 3px;
            margin-bottom: 4px;
        }
        .stat-card {
            background: white;
            padding: 3px;
            border-radius: 2px;
            text-align: center;
            border: 1px solid #e0e0e0;
            font-size: 9px;
        }
        .stat-value {
            font-size: 10px;
            font-weight: bold;
            color: #2c3e50;
        }
        .stat-label {
            color: #666;
        }
        .no-data {
            text-align: center;
            padding: 20px;
            color: #999;
            font-style: italic;
            font-size: 10px;
        }
         .back-button {
            background: rgba(255,255,255,0.2);
            color: white;
            padding: 4px 8px;
            border-radius: 3px;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            transition: background 0.3s ease;
        }
        .loading {
            text-align: center;
            padding: 10px;
            color: #666;
            font-size: 10px;
        }
        .sale-stats {
            background: linear-gradient(135deg, #667eea, #764ba2);
            color: white;
            padding: 6px;
            border-radius: 3px;
            margin-bottom: 4px;
        }
        form {
            margin: 0;
            padding: 0;
        }
        input[type="hidden"] {
            display: none;
        }
    </style>
</head>
<body>
    <div class="header">
        <div style="display: flex; align-items: center; gap: 10px;">
            <a href="home.php" class="back-button" title="Back to Home">
                <i style="font-size: 16px;">🏠</i>
            </a>
            <h1>📦 Mobile Bin Card</h1>
        </div>
        <div class="date-display">📅 <?php echo $displayDate; ?></div>
    </div>
    
    <div class="control-panel">
        <form method="POST" id="main-form">
            <div class="combo-section">
            <label for="repcode">REPCODE:</label>
                <select id="repcode" name="repcode" onchange="this.form.submit()">
                    <option value="">-- Select --</option>
                    <?php echo $repcodeOptions; ?>
                </select>
            </div>
            
            <input type="text" name="search_term" class="search-box" 
                   placeholder="Search stock number or description..." 
                   value="<?php echo htmlspecialchars($searchTerm); ?>"
                   onkeyup="handleSearch()">
                   
            <input type="hidden" name="stock_no" id="selected_stock" value="<?php echo $selectedStock; ?>">
            <input type="hidden" name="repcode" id="selected_repcode" value="<?php echo $selectedRepcode; ?>">
        </form>
    </div>
    
    <?php if (!empty($searchTerm)): ?>
    <div class="search-info">
        🔍 Search: "<?php echo htmlspecialchars($searchTerm); ?>"
        <?php if (!empty($searchResults)): ?>
        - Found <?php echo count($searchResults); ?> items
        <?php elseif (isset($_POST['search_term'])): ?>
        - No items found
        <?php endif; ?>
    </div>
    <?php endif; ?>
    
    <?php if (!empty($searchResults)): ?>
    <div class="grid-section full-width">
        <div class="section-title">📋 Stock Items (<?php echo count($searchResults); ?>)</div>
        <div class="grid-wrapper">
            <table class="grid">
                <thead>
                    <tr>
                        <th width="100">Stock No</th>
                        <th>Description</th>
                        <th width="120">Brand</th>
                        <th width="80">Qty</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($searchResults as $result): 
                        $isSelected = ($selectedStock == $result['STK_NO']) ? 'selected' : '';
                        $qtyClass = $result['QTYINHAND'] > 0 ? 'qty-high' : 'qty-low';
                    ?>
                    <tr class="<?php echo $isSelected; ?>" 
                        onclick="selectStock('<?php echo $result['STK_NO']; ?>', this)">
                        <td><strong><?php echo $result['STK_NO']; ?></strong></td>
                        <td><?php echo $result['DESCRIPT']; ?></td>
                        <td><?php echo $result['BRAND_NAME']; ?></td>
                        <td class="<?php echo $qtyClass; ?>" style="text-align: center;">
                            <?php echo $result['QTYINHAND']; ?>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
    <?php endif; ?>
    
    <?php
    // Calculate sales statistics
    $salesStats = calculateSalesStats($salesData);
    ?>
    
    <?php if (!empty($stockDetails) || !empty($transactionData)): ?>
    <div class="grid-container">
        <?php if (!empty($stockDetails)): ?>
        <div class="grid-section">
            <div class="section-title">📦 Stock Details</div>
            <div class="grid-wrapper">
                <table class="grid">
                    <thead>
                        <tr>
                            <th>Description</th>
                            <th width="80">Store</th>
                            <th width="60">Qty</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($stockDetails as $detail): 
                            $qtyClass = $detail['QTYINHAND'] > 0 ? 'qty-high' : 'qty-low';
                        ?>
                        <tr>
                            <td><?php echo $detail['DESCRIPTION']; ?></td>
                            <td><?php echo $detail['STO_CODE']; ?></td>
                            <td class="<?php echo $qtyClass; ?>" style="text-align: center;">
                                <?php echo $detail['QTYINHAND']; ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
        <?php endif; ?>
        
        <?php if (!empty($transactionData)): ?>
        <div class="grid-section">
            <div class="section-title">💰 Transaction History (After Inventory)</div>
            <div class="inventory-filter">
                📅 Showing records from: <strong><?php echo date('d/m/Y', strtotime($inventoryDate)); ?></strong> onwards | 
                Total Records: <strong><?php echo count($transactionData); ?></strong>
            </div>
            <?php if (!empty($salesData)): ?>
            <div class="sale-stats">
                <strong>Sales Summary:</strong> 
                Qty: <?php echo $salesStats['total_sales_qty']; ?> | 
                Revenue: $<?php echo number_format($salesStats['total_revenue'], 0); ?> | 
                Profit: $<?php echo number_format($salesStats['total_profit'], 0); ?>
            </div>
            <?php endif; ?>
            <div class="grid-wrapper">
                <table class="grid">
                    <thead>
                        <tr>
                            <th width="70">Date</th>
                            <th width="80">Ref No</th>
                            <th width="40">Qty</th>
                            <th width="40">Tru Qty</th>
                            <th width="50">LED</th>
                            <th width="60">REP</th>
                            <th width="50">Balance</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($transactionData as $trans): 
                            $ledClass = 'led-' . getLedType($trans['LEDINDI']);
                            $trnColorClass = getTransactionColorClass($trans['LEDINDI']);
                            $balance = $trans['BALANCE'];
                            $balanceClass = $balance > 0 ? 'balance-positive' : ($balance < 0 ? 'balance-negative' : 'balance-zero');
                        ?>
                        <tr class="<?php echo $trnColorClass; ?>">
                            <td><?php echo date('d/m/y', strtotime($trans['SDATE'])); ?></td>
                            <td><strong><?php echo $trans['REFNO']; ?></strong></td>
                            <td style="text-align: center; font-weight: bold;">
                                <?php echo $trans['QTY']; ?>
                            </td>
                            <td style="text-align: center;"><?php echo $trans['tru_qty']; ?></td>
                            <td class="<?php echo $ledClass; ?>" style="text-align: center;">
                                <?php echo $trans['LEDINDI']; ?>
                            </td>
                            <td style="text-align: center;"><?php echo $trans['sal_ex']; ?></td>
                            <td class="<?php echo $balanceClass; ?>">
                                <?php echo $balance; ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
        <?php endif; ?>
    </div>
    <?php endif; ?>
    
    <?php if (!empty($salesData)): ?>
    <div class="grid-section full-width">
        <div class="section-title">💰 Sales Data with Calculations</div>
        <div class="stats-bar">
            <div class="stat-card">
                <div class="stat-value"><?php echo $salesStats['sale_count']; ?></div>
                <div class="stat-label">Sales Count</div>
            </div>
            <div class="stat-card">
                <div class="stat-value"><?php echo $salesStats['total_sales_qty']; ?></div>
                <div class="stat-label">Total Qty</div>
            </div>
            <div class="stat-card">
                <div class="stat-value">$<?php echo number_format($salesStats['total_revenue'], 0); ?></div>
                <div class="stat-label">Revenue</div>
            </div>
            <div class="stat-card">
                <div class="stat-value">$<?php echo number_format($salesStats['total_profit'], 0); ?></div>
                <div class="stat-label">Profit</div>
            </div>
            <div class="stat-card">
                <div class="stat-value"><?php echo number_format($salesStats['profit_margin'], 1); ?>%</div>
                <div class="stat-label">Margin</div>
            </div>
        </div>
        <div class="grid-wrapper">
            <table class="grid">
                <thead>
                    <tr>
                        <th width="70">Date</th>
                        <th width="80">Ref No</th>
                        <th width="40">Qty</th>
                        <th width="80">Customer</th>
                        <th width="60">REP</th>
                        <th width="50">Cost</th>
                        <th width="50">Price</th>
                        <th width="50">Profit</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($salesData as $sale): 
                        $profit = $sale['PRICE'] - $sale['COST'];
                        $profitMargin = $sale['COST'] > 0 ? ($profit / $sale['COST']) * 100 : 0;
                        $profitClass = $profitMargin >= 20 ? 'profit-high' : 'profit-low';
                    ?>
                    <tr>
                        <td><?php echo date('d/m/y', strtotime($sale['SDATE'])); ?></td>
                        <td><strong><?php echo $sale['REFNO']; ?></strong></td>
                        <td style="text-align: center; background-color: #fff3e0;">
                            <?php echo $sale['QTY']; ?>
                        </td>
                        <td><?php echo $sale['CUS_NAME']; ?></td>
                        <td style="text-align: center;"><?php echo $sale['SAL_EX']; ?></td>
                        <td style="text-align: right;">$<?php echo number_format($sale['COST'], 1); ?></td>
                        <td style="text-align: right;">$<?php echo number_format($sale['PRICE'], 1); ?></td>
                        <td class="<?php echo $profitClass; ?>" style="text-align: right;">
                            $<?php echo number_format($profit, 1); ?>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
    <?php endif; ?>
    
    <?php if (!empty($customerSales)): ?>
    <div class="chart-container">
        <div class="chart-title">👥 Current Month Sales by Customer</div>
        <div class="chart customer-chart">
            <?php 
            $maxQty = max(array_column($customerSales, 'total_qty'));
            foreach ($customerSales as $customer): 
                $height = $maxQty > 0 ? ($customer['total_qty'] / $maxQty) * 90 : 0;
            ?>
            <div class="chart-bar-container">
                <div class="chart-bar" style="height: <?php echo $height; ?>%">
                    <div class="chart-value"><?php echo $customer['total_qty']; ?></div>
                </div>
                <div class="chart-label">
                    <?php 
                    $customerName = $customer['CUS_NAME'];
                    echo strlen($customerName) > 8 ? substr($customerName, 0, 6) . '..' : $customerName;
                    ?>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
    <?php endif; ?>
    
    <?php if (!empty($monthlySalesByRepcode)): ?>
    <div class="chart-container">
        <div class="chart-title">📈 Last 6 Months - SAL_EX: <?php echo $selectedRepcode; ?></div>
        <div class="chart repcode-chart">
            <?php 
            $maxMonthlyQty = max(array_column($monthlySalesByRepcode, 'total_qty'));
            foreach ($monthlySalesByRepcode as $monthly): 
                $height = $maxMonthlyQty > 0 ? ($monthly['total_qty'] / $maxMonthlyQty) * 90 : 0;
            ?>
            <div class="chart-bar-container">
                <div class="chart-bar" style="height: <?php echo $height; ?>%">
                    <div class="chart-value"><?php echo $monthly['total_qty']; ?></div>
                </div>
                <div class="chart-label"><?php echo substr($monthly['month'], 5); ?></div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
    <?php elseif (!empty($selectedRepcode)): ?>
    <div class="chart-container">
        <div class="no-data">No sales data for SAL_EX: <?php echo $selectedRepcode; ?></div>
    </div>
    <?php endif; ?>
    
    <?php if (empty($searchResults) && empty($selectedStock) && empty($selectedRepcode)): ?>
    <div class="chart-container">
        <div class="loading">
            💡 <strong>Stock Management System</strong><br>
            • Search for stock items<br>
            • Select REPCODE for sales charts<br>
            • Click items for details
        </div>
    </div>
    <?php endif; ?>

    <script>
        let searchTimeout;
        
        function handleSearch() {
            clearTimeout(searchTimeout);
            searchTimeout = setTimeout(function() {
                document.getElementById('selected_stock').value = '';
                document.getElementById('main-form').submit();
            }, 500);
        }
        
        function selectStock(stockNo, element) {
            // Remove selected class from all rows
            const allRows = document.querySelectorAll('.grid tr');
            allRows.forEach(row => row.classList.remove('selected'));
            
            // Add selected class to clicked row
            element.classList.add('selected');
            
            // Set the selected stock and submit form
            document.getElementById('selected_stock').value = stockNo;
            document.getElementById('main-form').submit();
        }
        
        // Auto-focus search box on page load
        document.addEventListener('DOMContentLoaded', function() {
            const searchBox = document.querySelector('input[name="search_term"]');
            if (searchBox) {
                searchBox.focus();
                const value = searchBox.value;
                searchBox.value = '';
                searchBox.value = value;
            }
        });
    </script>
</body>
</html>

<?php
// Close database connection
mysqli_close($conn);
?>